﻿
/****************************************************************************/
/*Copyright (c) 2011, Florent DEVILLE.                                      */
/*All rights reserved.                                                      */
/*                                                                          */
/*Redistribution and use in source and binary forms, with or without        */
/*modification, are permitted provided that the following conditions        */
/*are met:                                                                  */
/*                                                                          */
/* - Redistributions of source code must retain the above copyright         */
/*notice, this list of conditions and the following disclaimer.             */
/* - Redistributions in binary form must reproduce the above                */
/*copyright notice, this list of conditions and the following               */
/*disclaimer in the documentation and/or other materials provided           */
/*with the distribution.                                                    */
/* - The names of its contributors cannot be used to endorse or promote     */
/*products derived from this software without specific prior written        */
/*permission.                                                               */
/* - The source code cannot be used for commercial purposes without         */
/*its contributors' permission.                                             */
/*                                                                          */
/*THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS       */
/*"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT         */
/*LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS         */
/*FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE            */
/*COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,       */
/*INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,      */
/*BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;          */
/*LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER          */
/*CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT        */
/*LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN         */
/*ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE           */
/*POSSIBILITY OF SUCH DAMAGE.                                               */
/****************************************************************************/
  
using System.Collections.Generic;
using System.Diagnostics;

using Microsoft.Xna.Framework.Audio;
using Microsoft.Xna.Framework.Content;

using GE.Tools;

namespace GE.Audio
{
    /// <summary>
    /// Manages the audio.
    /// </summary>
    class Audio
    {
        /// <summary>
        /// Unique instance of the Audio class.
        /// </summary>
        private static Audio m_instance = new Audio ();

        /// <summary>
        /// List of sound
        /// </summary>
        private Dictionary<string, SoundEffectInstance> _soundBank;

        //private
        /// <summary>
        /// Content manager
        /// </summary>
        ContentManager _content;

        /// <summary>
        /// List of playlist
        /// </summary>
        List<Playlist> _listPlaylist;

        /// <summary>
        /// Unique instance of the Audio class.
        /// </summary>
        public static Audio Instance
        {
            get { return m_instance; }
        }

        /// <summary>
        /// Private constructor.
        /// </summary>
        private Audio()
        {
            _soundBank = new Dictionary<string, SoundEffectInstance>();
            _listPlaylist = new List<Playlist>();
        }

        /// <summary>
        /// Initialise the audio component
        /// </summary>
        /// <param name="content"></param>
        public void init(ContentManager content)
        {
            _content = content;
        }

        /// <summary>
        /// Load a sound
        /// </summary>
        /// <param name="soundName"></param>
        /// <param name="assetName"></param>
        /// <returns></returns>
        public SoundEffectInstance loadSound(string soundName, string assetName)
        {
            SoundEffect newSong = _content.Load<SoundEffect>(assetName);
            SoundEffectInstance instance = newSong.CreateInstance();
            _soundBank.Add(soundName, instance);
            return instance;
        }

        /// <summary>
        /// Create a playlist
        /// </summary>
        /// <returns></returns>
        public Playlist createPlaylist()
        {
            Playlist newPlaylist = new Playlist();
            _listPlaylist.Add(newPlaylist);
            return newPlaylist;
        }

        /// <summary>
        /// Plays a sound.
        /// </summary>
        /// <param name="name"></param>
        public void playSound(string name)
        {
            _soundBank[name].Stop(true);
            _soundBank[name].Play();
        }

        /// <summary>
        /// Stops a sound
        /// </summary>
        /// <param name="name"></param>
        public void stopSound(string name)
        {
            _soundBank[name].Stop();
        }

        /// <summary>
        /// Updates the Audio component.
        /// </summary>
        public void update()
        {
            foreach (Playlist p in _listPlaylist)
                p.update();
        }
    }
}
